const express = require("express");
const bodyParser = require("body-parser");
const { MongoClient, ObjectId } = require("mongodb");
const multer = require("multer");
const app = express();
const port = 5000;
const axios = require("axios"); // Import axios to make HTTP requests


app.use(bodyParser.json());

const WEATHER_API_KEY = 'bf7563aaea3647e7aff03240241704';
const WEATHER_BASE_URL = 'http://api.weatherapi.com/v1';

// MongoDB URI - Please ensure this is kept secret in a real-world scenario!

async function execute(fn, data) {
  const uri = "mongodb+srv://admin:Assassin2@notesapp.wveaujr.mongodb.net/";

  const client = new MongoClient(uri);

  try {
    // Connect to the MongoDB cluster
    await client.connect();
    await fn(client, data);
  } finally {
    await client.close();
  }
}

app.post("/data", (req, res) => {
  execute(createTask, req.body).catch(console.error);
  async function createTask(client, data) {
    const result = await client
      .db("Portfolio")
      .collection("About")
      .insertOne(data);
    res.json(result);
  }
});

app.get("/data", (req, res) => {
  execute(showTasks, {}).catch(console.error);
  async function showTasks(client, data) {
    const cursor = await client.db("Portfolio").collection("About").find();
    const allTasks = await cursor.toArray();
    res.json(allTasks);
  }
});

app.patch("/data/:id", (req, res) => {
  execute(updateTask, req.body).catch(console.error);
  async function updateTask(client, data) {
    const result = await client
      .db("Portfolio")
      .collection("About")
      .updateOne({ _id: ObjectId(req.params.id) }, { $set: data });
    res.json(result);
  }
});



// New route to fetch weather data for Mississauga
app.get("/weather", async (req, res) => {
  try {
    const response = await axios.get(`${WEATHER_BASE_URL}/current.json`, {
      params: {
        key: WEATHER_API_KEY,
        q: 'Mississauga'
      }
    });
    res.json(response.data);
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: 'Failed to fetch weather data' });
  }
});

app.listen(port, () => {
  console.log(`Server listening on port ${port}!`);
});