document.addEventListener("DOMContentLoaded", function (event) {
  // array with texts to type in typewriter
  var dataText = ["I am", "Anitha Nathan"];

  // type one text in the typwriter
  // keeps calling itself until the text is finished
  function typeWriter(text, i, fnCallback) {
    // chekc if text isn't finished yet
    if (i < text.length) {
      // add next character to h1
      document.querySelector(".Anitha").innerHTML =
        text.substring(0, i + 1) + '<span aria-hidden="true"></span>';

      // wait for a while and call this function again for next character
      setTimeout(function () {
        typeWriter(text, i + 1, fnCallback);
      }, 60);
    }
    // text finished, call callback if there is a callback function
    else if (typeof fnCallback == "function") {
      // call callback after timeout
      setTimeout(fnCallback, 700);
    }
  }
  // start a typewriter animation for a text in the dataText array
  function StartTextAnimation(i) {
    if (typeof dataText[i] == "undefined") {
      setTimeout(function () {
        StartTextAnimation(0);
      }, 5000);
    }
    // check if dataText[i] exists
    if (i < dataText[i].length) {
      // text exists! start typewriter animation
      typeWriter(dataText[i], 0, function () {
        // after callback (and whole text has been animated), start next text
        StartTextAnimation(i + 1);
      });
    }
  }
  // start the text animation
  StartTextAnimation(0);
});

document.addEventListener("DOMContentLoaded", function (event) {
  // array with texts to type in typewriter
  var dataText = [
    "I transform ideas into immersive digital realities through creativity and code.",
  ];

  // type one text in the typwriter
  // keeps calling itself until the text is finished
  function typeWriter(text, i, fnCallback) {
    // chekc if text isn't finished yet
    if (i < text.length) {
      // add next character to h1
      document.querySelector("h2").innerHTML =
        text.substring(0, i + 1) + '<span aria-hidden="true"></span>';

      // wait for a while and call this function again for next character
      setTimeout(function () {
        typeWriter(text, i + 1, fnCallback);
      }, 30);
    }
    // text finished, call callback if there is a callback function
    else if (typeof fnCallback == "function") {
      // call callback after timeout
      setTimeout(fnCallback, 700);
    }
  }
  // start a typewriter animation for a text in the dataText array
  function StartTextAnimation(i) {
    if (typeof dataText[i] == "undefined") {
      setTimeout(function () {
        StartTextAnimation(0);
      }, 20000);
    }
    // check if dataText[i] exists
    if (i < dataText[i].length) {
      // text exists! start typewriter animation
      typeWriter(dataText[i], 0, function () {
        // after callback (and whole text has been animated), start next text
        StartTextAnimation(i + 1);
      });
    }
  }
  // start the text animation
  setTimeout(function () {
    StartTextAnimation(0);
  }, 3000); // delay in milliseconds (5000ms = 5 seconds)
});

//HEADER SCROLL//////////////////////////////////////////////////
    window.addEventListener("scroll", () => {
      const scrollPosition = window.scrollY;
      const documentHeight = document.documentElement.scrollHeight;
      const windowHeight = window.innerHeight;
      const scrollPercentage = (scrollPosition / (documentHeight - windowHeight)) * 100;

      const about = document.getElementById("about");
      const header = document.getElementById("header");
      const projects = document.getElementsByClassName(".toggle");

      if (scrollPercentage >= 10) {
        about.style.opacity = 1;
      } else {
        about.style.opacity = 0;
      }

      if (scrollPercentage >= 50) {
        header.style.opacity = 0;
      } else {
        header.style.opacity = 1;
      }
    });

    document.addEventListener('DOMContentLoaded', () => {
      const aboutDiv = document.getElementById('about');
      const toggleDiv = document.querySelector('.toggle');

      const handleScroll = () => {
        const aboutRect = aboutDiv.getBoundingClientRect();
        const windowHeight = window.innerHeight;
        const toggleHeight = toggleDiv.offsetHeight;

        if (window.innerWidth > 1000) { // Apply this only for larger screens
          if (aboutRect.bottom <= windowHeight) {
            toggleDiv.style.position = 'fixed';
            toggleDiv.style.bottom = '0';
            toggleDiv.style.display = 'block';
            aboutDiv.style.marginBottom = `${toggleHeight}px`;
          } else {
            toggleDiv.style.position = 'relative';
            toggleDiv.style.bottom = 'auto';
            aboutDiv.style.marginBottom = '0';
          }
        } else {
          toggleDiv.style.position = 'static';
          toggleDiv.style.bottom = 'auto';
          toggleDiv.style.display = 'block';
          aboutDiv.style.marginBottom = '0';
        }
      };

      window.addEventListener('scroll', handleScroll);
      handleScroll(); // Initial check
    });

    document.querySelector(".button").addEventListener("click", function () {
      document.querySelector(".toggle").scrollIntoView({
        behavior: "smooth",
      });
    });

    document.querySelector("#pfp").addEventListener("click", function () {
      document.querySelector("#about").scrollIntoView({
        behavior: "smooth",
      });
    });

    window.addEventListener('scroll', function() {
      let flower = document.getElementById('flower');
      let scrollTop = window.pageYOffset || document.documentElement.scrollTop;
      let windowHeight = window.innerHeight;
      let scrollFraction = scrollTop / (windowHeight / 2);  // More sensitive to scroll

      let opacity = 1 - scrollFraction;

      if (opacity >= 0) {
        flower.style.opacity = opacity;
      } else {
        flower.style.opacity = 0.01;
      }
    });

    document.addEventListener('DOMContentLoaded', function() {
      var about = document.getElementById('about');
      var aboutflower = document.getElementById('aboutflower');

      var observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            aboutflower.style.display = 'block';
          } else {
            aboutflower.style.display = 'none';
          }
        });
      }, { threshold: [0.1] });

      observer.observe(about);
    });